//=============================================================================
// ResistPenetrateTag.js
// ----------------------------------------------------------------------------
// (C)2023 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/03/06 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 耐性貫通タグ（スキル/アイテム）
 * @target MZ
 * @author くろあめ
 * 
 * @help
 * スキルやアイテムのメモに <PenetrateElementGuard> と、記述すると
 * そのスキルやアイテムのダメージ計算時に、属性耐性を無視し
 * 属性ダメージ率：100% の最低倍率を保証します。
 * 
 * 通常攻撃属性で複合属性になっている場合でも、上記のタグが記載されていれば
 * 属性ダメージ率：100% の最低倍率を保証します。
 *
 * 弱点属性で攻撃した場合は、特に動作に変更ありません
 * 攻撃属性中の最大倍率の属性が、属性倍率として適用されます。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

// 属性計算
const _Game_Action_calcElementRate_kop = Game_Action.prototype.calcElementRate;
Game_Action.prototype.calcElementRate = function(target) {
  var result = _Game_Action_calcElementRate_kop.apply(this, arguments);
  //console.log("before rate:"+String(result));
  if(result < 1.0 && this.item() && this.item().meta && this.item().meta.PenetrateElementGuard){
      result = 1.0;
  }
  //console.log("After rate:"+String(result));
  //console.log(this.item().meta);
  return result;
};

})();